/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class PortalState {
    public final class_5321<class_1937> fromWorld;
    public final class_243 fromPos;
    public final class_5321<class_1937> toWorld;
    public final class_243 toPos;
    public final double scaling;
    public final DQuaternion rotation;
    public final DQuaternion orientation;
    public final double width;
    public final double height;
    public final double thickness;
    public final boolean isMirror;

    public PortalState(class_5321<class_1937> fromWorld, class_243 fromPos, class_5321<class_1937> toWorld, class_243 toPos, double scaling, DQuaternion rotation, DQuaternion orientation, double width, double height) {
        this.fromWorld = fromWorld;
        this.fromPos = fromPos;
        this.toWorld = toWorld;
        this.toPos = toPos;
        this.scaling = scaling;
        this.rotation = rotation;
        this.orientation = orientation;
        this.width = width;
        this.height = height;
        this.thickness = 0.0;
        this.isMirror = false;
    }

    public PortalState(class_5321<class_1937> fromWorld, class_243 fromPos, class_5321<class_1937> toWorld, class_243 toPos, double scaling, DQuaternion rotation, DQuaternion orientation, double width, double height, double thickness, boolean isMirror) {
        this.fromWorld = fromWorld;
        this.fromPos = fromPos;
        this.toWorld = toWorld;
        this.toPos = toPos;
        this.scaling = scaling;
        this.rotation = rotation;
        this.orientation = orientation;
        this.width = width;
        this.height = height;
        this.thickness = thickness;
        this.isMirror = isMirror;
    }

    public PortalState withThisSideUpdated(UnilateralPortalState thisSide, boolean lockScale) {
        UnilateralPortalState otherSide = UnilateralPortalState.extractOtherSide(this);
        if (lockScale) {
            otherSide = new UnilateralPortalState.Builder().from(otherSide).width(thisSide.width() * this.scaling).height(thisSide.height() * this.scaling).thickness(thisSide.thickness() * this.scaling).build();
        }
        PortalState newPortalState = UnilateralPortalState.combine(thisSide, otherSide);
        return newPortalState;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("fromWorld", this.fromWorld.method_29177().toString());
        tag.method_10582("toWorld", this.toWorld.method_29177().toString());
        Helper.putVec3d(tag, "fromPos", this.fromPos);
        Helper.putVec3d(tag, "toPos", this.toPos);
        tag.method_10549("scaling", this.scaling);
        tag.method_10549("width", this.width);
        tag.method_10549("height", this.height);
        tag.method_10549("thickness", this.thickness);
        tag.method_10566("rotation", this.rotation.toTag());
        tag.method_10566("orientation", this.orientation.toTag());
        tag.method_10556("isMirror", this.isMirror);
        return tag;
    }

    public static PortalState fromTag(class_2487 tag) {
        class_5321<class_1937> fromWorld = Helper.dimIdToKey(tag.method_10558("fromWorld"));
        class_5321<class_1937> toWorld = Helper.dimIdToKey(tag.method_10558("toWorld"));
        class_243 fromPos = Helper.getVec3d(tag, "fromPos");
        class_243 toPos = Helper.getVec3d(tag, "toPos");
        double scaling = tag.method_10574("scaling");
        double width = tag.method_10574("width");
        double height = tag.method_10574("height");
        double thickness = tag.method_10574("thickness");
        DQuaternion rotation = DQuaternion.fromTag((class_2520)tag.method_10562("rotation"));
        DQuaternion orientation = DQuaternion.fromTag((class_2520)tag.method_10562("orientation"));
        boolean isMirror = tag.method_10577("isMirror");
        return new PortalState(fromWorld, fromPos, toWorld, toPos, scaling, rotation, orientation, width, height, thickness, isMirror);
    }

    public static PortalState interpolate(PortalState a, PortalState b, double progress, boolean inverseScale) {
        Validate.isTrue((a.fromWorld == b.fromWorld ? 1 : 0) != 0);
        Validate.isTrue((a.toWorld == b.toWorld ? 1 : 0) != 0);
        return new PortalState(a.fromWorld, Helper.interpolatePos(a.fromPos, b.fromPos, progress), a.toWorld, Helper.interpolatePos(a.toPos, b.toPos, progress), PortalState.interpolateScale(a, b, progress, inverseScale), DQuaternion.interpolate(a.rotation, b.rotation, progress), DQuaternion.interpolate(a.orientation, b.orientation, progress), class_3532.method_16436((double)progress, (double)a.width, (double)b.width), class_3532.method_16436((double)progress, (double)a.height, (double)b.height), class_3532.method_16436((double)progress, (double)a.thickness, (double)b.thickness), a.isMirror);
    }

    private static double interpolateScale(PortalState a, PortalState b, double progress, boolean inverseScale) {
        if (inverseScale) {
            return 1.0 / class_3532.method_16436((double)progress, (double)(1.0 / a.scaling), (double)(1.0 / b.scaling));
        }
        return class_3532.method_16436((double)progress, (double)a.scaling, (double)b.scaling);
    }

    public class_243 getPointOnSurface(double localX, double localY) {
        class_243 axisW = McHelper.getAxisWFromOrientation(this.orientation);
        class_243 axisH = McHelper.getAxisHFromOrientation(this.orientation);
        return axisW.method_1021(localX).method_1019(axisH.method_1021(localY)).method_1019(this.fromPos);
    }

    public class_243 transformPoint(class_243 pos) {
        class_243 offset = pos.method_1020(this.fromPos);
        class_243 offsetTransformed = this.transformVec(offset);
        return offsetTransformed.method_1019(this.toPos);
    }

    public class_243 transformVec(class_243 vec) {
        class_243 rotated = this.rotation.rotate(vec);
        class_243 scaled = rotated.method_1021(this.scaling);
        if (this.isMirror) {
            return Mirror.mirroredVec(scaled, this.getNormal());
        }
        return scaled;
    }

    public class_243 worldPosToPortalLocalPos(class_243 worldPos) {
        class_243 axisW = McHelper.getAxisWFromOrientation(this.orientation);
        class_243 axisH = McHelper.getAxisHFromOrientation(this.orientation);
        class_243 origin = this.fromPos;
        class_243 offset = worldPos.method_1020(origin);
        return new class_243(offset.method_1026(axisW), offset.method_1026(axisH), offset.method_1026(axisW.method_1036(axisH)));
    }

    public class_243 portalLocalPosToWorldPos(class_243 portalLocalPos) {
        class_243 axisW = McHelper.getAxisWFromOrientation(this.orientation);
        class_243 axisH = McHelper.getAxisHFromOrientation(this.orientation);
        class_243 origin = this.fromPos;
        return origin.method_1019(axisW.method_1021(portalLocalPos.field_1352)).method_1019(axisH.method_1021(portalLocalPos.field_1351)).method_1019(axisW.method_1036(axisH).method_1021(portalLocalPos.field_1350));
    }

    public class_243 getLocalPosTransformed(double collisionLocalX, double collisionLocalY) {
        return this.transformPoint(this.portalLocalPosToWorldPos(new class_243(collisionLocalX, collisionLocalY, 0.0)));
    }

    public class_243 getNormal() {
        return McHelper.getNormalFromOrientation(this.orientation);
    }

    public class_243 getContentDirection() {
        return this.rotation.rotate(this.getNormal().method_1021(-1.0));
    }

    public UnilateralPortalState getThisSideState() {
        return UnilateralPortalState.extractThisSide(this);
    }

    public UnilateralPortalState getOtherSideState() {
        return UnilateralPortalState.extractOtherSide(this);
    }
}

